#################################
### Pub.tcl                   ###
### Version 1.8	BETA 3        ###
### By Wcc and MatriX-        ###
### wcc@techmonkeys.org       ###
### jeremy@miracle1.net       ###
### http://dawg.oc255.net:81/ ###
### EFnet #|DAWG|Tcl          ###
#################################

############################################################################
### Copyright  2000 - 2002 |DAWG| Scripting Group. All rights reserved. ###
############################################################################

###############################################################################
## This script provides 49 in-channel commands for interacting with the bot. ##
## Auth and SubOp are supported.                                             ##
###############################################################################

##############
## COMMANDS ##
###################################################################
## PUB ## <command prefix> <command>                             ##
######### Use <command prefix> help for a full list of commands. ##
###################################################################
## MSG ## /msg <bot> auth <password>	                         ##
######### Authorizes you to use pub commands.                    ##
######### ------------------------------------------------------ ##
######### /msg <bot> deauth		                         ##
######### De-authorizes you from using pub commands.             ##
###################################################################
## DCC ## .pubhelp                                               ##
######### Shows script help.                                     ##
######### ------------------------------------------------------ ##
######### .chanset <channel> +/-subop                            ##
######### Enables or disables subop for the specified channel.   ##
######### ------------------------------------------------------ ##
######### .chanset <channel> +/-auth                             ##
######### Enables or disables auth for the specified channel.    ##
###################################################################

##########################################################
## Just load the script, set the variables, and rehash.	##
##########################################################

##############################################################################
# Set the command prefixes (seperated by a space) for all pub commands here. #
# You can use "%botnick" to use the bot's nick.                              #
##############################################################################

set pub_setting(prefix) "iso dawg %botnick"

###########################
# Enable the die command? #
###########################

set pub_setting(enable-die) 0

##############################################################################
# Allow subops to use the bot to preform some op commands on +subop channels #
# without ops?                                                               #
##############################################################################

set pub_setting(subop) 1

#######################################
# Set the flag to give sub-opd users. #
#######################################

set pub_setting(subop_flag) "S"

###################################
# Force auth on for all channels? #
###################################

set pub_setting(allauth) 0

###############################################################################
# Advanced: You can override the reply of <command prefix> uptime by setting  #
# it here. Default setting is recommended. Available variables are: %version, #
# %ostype, %osversion, %osbyteorder, %user, %machine, and %platform.          #
###############################################################################

set pub_setting(version) "Eggdrop %version on %ostype %osversion."

################################################################################
# Advanced: Set the version reply to send non-master users here.  Available    #
# variables are: %version, %ostype, %osversion, %osbyteorder, %user, %machine, #
# and %platform.                                                               #
################################################################################

set pub_setting(hversion) "Eggdrop %version."

################################################################
# Send a notice when a nick does not have access to a command? #
################################################################

set pub_setting(noticeacc) 1

#######################################################
# Enable use of bold in some messages to the channel? #
#######################################################

set pub_setting(bold) 1

###################################
# Enable use of bold in DCC chat? #
###################################

set pub_setting(dbold) 1

#######################################
# Prefix "PUB:" in DCC chat messages? #
#######################################

set pub_setting(PUB:) 1

##################################################################
# Set the encryption key here. (Used for the "randpass" command) #
##################################################################

set pub_setting(key) "bd4GGfh47H36dh43"

######################################################################
# Set the 2nd encryption key here. (Used for the "randpass" command) #
######################################################################

set pub_setting(rand) "99544684584"

####################
# Code begins here #
####################

if {$numversion < 1060800} { putlog "\002PUB:\002 \002WARNING:\002 This script is intended to run on eggdrop 1.6.8 or later." }
if {[info tclversion] < 8.2} { putlog "\002PUB:\002 \002WARNING:\002 This script is intended to run on Tcl Version 8.2 or later." }

bind pubm - * pub_parsecmd
bind dcc - pubhelp pub_help_dcc
bind msg - auth pub_auth
bind msg - deauth pub_deauth
bind part - * pub_deauth_part
bind sign - * pub_deauth_quit
bind splt - * pub_deauth_quit
setudef flag subop
setudef flag auth

set pub_setting(commandlist) {
	access gethand invite die chattr randpass -chan +chan raw restart disable enable rehash jump hosts uptime chanlist +host -host topic banunban
	global cycle subop aop master owner autovoice wipe act say akick msg save mode voice devoice op deop deopme opme voiceme kick help version devoiceme
	unixtime
}
proc pub_dopre {} {
	global pub_setting
	if {!$pub_setting(PUB:)} { return "" }
	if {!$pub_setting(dbold)} { return "PUB: " }
	return "\002PUB:\002 "
}
proc pub_bold {text} {
	global pub_setting
	if {$pub_setting(bold)} { return \002$text\002 }
	return $text
}
proc pub_putmsg {chan text} { putserv "PRIVMSG $chan :$text" }
proc pub_ncm {pattern string} { return [string match [string tolower $pattern] [string tolower $string]] }
proc pub_ncc {pattern string} { return [expr {([string compare [string tolower $pattern] [string tolower $string]] == 0)?1:0}] }
proc pub_sindex {1 2} { return [join [lrange $1 $2 $2]] }
proc pub_putdcc {idx text} { putdcc $idx "[pub_dopre]$text" }
proc pub_auth {nick uhost hand text} {
	global botnick
	if {![validuser $hand]} { putserv "NOTICE $nick :You are not a bot user." ; return }
	if {[lindex [split $text] 0] == ""} { putserv "NOTICE $nick :Usage: /msg $botnick auth <password>" ; return }
	if {![passwdok $hand [lindex [split $text] 0]]} { putserv "NOTICE $nick :Invalid password." ; return }
	if {[matchattr $hand +Q]} { putserv "NOTICE $nick :You are already authorized." ; return }
	chattr $hand +Q
	putserv "NOTICE $nick :You are now authorized."
}
proc pub_deauth {nick uhost hand text} {
	if {![validuser $hand]} { putserv "NOTICE $nick :You are not a bot user." ; return }
	if {![matchattr $hand +Q]} { putserv "NOTICE $nick :You are not authorized." ; return }
	chattr $hand -Q
	putserv "NOTICE $nick :You are no longer authorized."
}
proc pub_deauth_quit {nick uhost hand chan {text ""}} {
	if {[validuser $hand] && [matchattr $hand +Q]} { chattr $hand -Q }
}
proc pub_deauth_part {nick uhost hand chan text} {
	if {[validuser $hand] && ![onchan $nick] && [matchattr $hand +Q]} { chattr $hand -Q }
}
proc pub_help_dcc {hand idx text} {
	global pub_setting
	foreach v [list to so vo] { set $v 0 }
	foreach c [channels] {
		if {$pub_setting(subop)} { set subopchan [expr ([lsearch -exact [channel info $c] +subop] != -1)?1:0] }
		set n [expr [matchattr $hand n|n $c]?1:0]
		set m [expr [matchattr $hand m|m $c]?1:0]
		if {([matchattr $hand o|o $c] || [isop [hand2nick $hand] $c]) && ![matchattr $hand d|d $c]} { set to 1 }
		if {([matchattr $hand o|o $c] || [isop [hand2nick $hand] $c] || ($subopchan && [matchattr $hand |+v$pub_setting(subop_flag) $c])) && ![matchattr $hand d|d $c]} { set so 1 }
		if {[matchattr $hand ov|ov $c] || [isop [hand2nick $hand] $c] || [isvoice [hand2nick $hand] $c] || ($subopchan && [matchattr $hand |+v$pub_setting(subop_flag) $c])} { set vo 1 }
	}
	pub_putdcc $idx "Usage: $pub_setting(prefix) <command>"
	pub_putdcc $idx "Commands:"
	if {[matchattr $hand n]} {
		pub_putdcc $idx "+Chan <channel> - Adds a channel to the bot's channel list."
		pub_putdcc $idx "-Chan <channel> - Removes a channel from the bot's channel list."
		pub_putdcc $idx "+Host <nick> <host> - Adds a hostmask to a nick's handle."
		pub_putdcc $idx "-Host <nick> <host> - Removes a hostmask from a nick's handle."
	}
	pub_putdcc $idx "Access \[nick\] - Shows the access for a nick."
	if {$m} {
		pub_putdcc $idx "Act <action> - Makes the bot preform an action in the channel."
		pub_putdcc $idx "Akick <add/del/list> \[<host\] \[reason\] - Adds, deletes, and lists akicks in the channel."
		pub_putdcc $idx "AOP <add/del> <nick> - Adds or removes a nick from the Channel Op list."
	}
	if {$so} {
		pub_putdcc $idx "Autovoice <add/del> <nick> - Adds or deletes a nick from the channel Auto-Voice list."
		pub_putdcc $idx "Ban <nick/hostmask> <reason> - Adds a nick or host to the channel ban list."
	}
	if {[matchattr $hand m]} { pub_putdcc $idx "Chanlist - Shows a list of channels the bot is on." }
	if {[matchattr $hand n]} { pub_putdcc $idx "Chattr <nick> <flags> \[channel\] - Changes the flags of a user." }
	if {[matchattr $hand m]} { pub_putdcc $idx "Cycle - Makes the bot cycle the channel." }
	if {$to} {
		pub_putdcc $idx "Deop - Makes the bot de-op a nick."
		pub_putdcc $idx "Deopme - Makes the bot de-op you."
	}
	if {$so} { pub_putdcc $idx "Devoice <nick> - Makes the bot de-voice a nick." }
	if {$vo} { pub_putdcc $idx "Devoiceme - Makes the bot de-voice you." }
	if {[matchattr $hand n]} {
		if {$pub_setting(enable-die) && [matchattr $hand n]} { pub_putdcc $idx "Die - Kills the bot." }
		pub_putdcc $idx "Disable <nick> - Prevents a nick from using any of the commands."
		pub_putdcc $idx "Enable <nick> - Allows a nick to use commands after being disabled."
	}
	pub_putdcc $idx "GetHand <nick> - Shows the handle of a nick."
	if {[matchattr $hand m]} {
		pub_putdcc $idx "Global <message> - Sends a message to every channel the bot is on."
		pub_putdcc $idx "Hosts <nick> - Shows all hostmasks for a nick's handle."
	}
	pub_putdcc $idx "Help - Shows this help message."
	pub_putdcc $idx "Invite \[nick\] <channel> - Invites you or another nick to a channel."
	if {[matchattr $hand m]} { pub_putdcc $idx "Jump \[server\] - Makes the bot change servers." }
	if {$so} { pub_putdcc $idx "Kick <nick> \[reason\] - Kicks a nick from the channel." }
	if {$n}  { pub_putdcc $idx "Master <add/del> <nick> - Adds or removes a nick from the Channel Master list." }
	if {$to} { pub_putdcc $idx "Mode <modes> - Sets a mode on the channel." }
	if {[matchattr $hand m]} { pub_putdcc $idx "Msg <nick/channel> - Sends a message to a nick or channel." }
	if {$to} {
		pub_putdcc $idx "Op <nick> - Makes the bot op a nick."
		pub_putdcc $idx "Opme - Makes the bot op you."
	}
	if {[matchattr $hand n]} {
		pub_putdcc $idx "Owner <add/del> <nick> - Adds or removes a nick from the Channel Owner list."
		pub_putdcc $idx "RandPass <nick> - Sets a random password for a nick."
		pub_putdcc $idx "Raw <commands> - Sends raw commands to the irc server."
	}
	if {[matchattr $hand m]} { pub_putdcc $idx "Rehash - Rehashes the bot." }
	if {[matchattr $hand n]} { pub_putdcc $idx "Restart - Restarts the bot." }
	if {$m} {
		pub_putdcc $idx "Save - Saves the bot's userfile."
		pub_putdcc $idx "Say - Makes the bot say something in the channel."
	}
	if {$pub_setting(subop) && $to} { pub_putdcc $idx "SubOp - Adds or removes a nick from the channel SubOp list." }
	if {$so} {
		pub_putdcc $idx "Topic <new topic> - Sets a new topic on the channel."
		pub_putdcc $idx "Unban <banmask> - Makes the bot unban a banmask."
	}
	if {[matchattr $hand m]} { pub_putdcc $idx "Uptime - Shows the bot's uptime." }
	putdcc $idx "Version - Shows the bot's version information."
	if {$so} { pub_putdcc $idx "Voice <nick> - Makes the bot voice a nick." }
	if {$vo} { pub_putdcc $idx "Voiceme - Makes the bot voice you." }
	if {[matchattr $hand n]} { pub_putdcc $idx "Wipe <nick> - Wipes all access from a nick." }
}
proc pub_parsecmd {nick uhost hand chan text} {
	global pub_setting version uptime botnick handlen tcl_platform
	if {[matchattr $hand D]} { return } 
	set authed [expr ([matchattr $hand +Q] || ([lsearch -exact [channel info $chan] +auth] == -1 && !$pub_setting(allauth)))?1:0]
	set usesubop [expr ([lsearch -exact [channel info $chan] +subop] != -1)?1:0]
	set botuptime [duration [expr [unixtime] - $uptime]]
	regsub -all "%botnick" $pub_setting(prefix) [string tolower $botnick] prefix
	if {[lsearch -exact $prefix [split [string tolower [join [lrange [split $text] 0 0]]]]] == -1} { return }
	set extxt [lrange [split $text] 1 end]
	set text [join [lrange [split $text] 1 end]]
	set cmd [split [string tolower [join [lindex $extxt 0]]]]
	regsub -all -- "%version" $pub_setting(version) $version botversion
	regsub -all -- "%ostype" $botversion $tcl_platform(os) botversion
	regsub -all -- "%osversion" $botversion $tcl_platform(osVersion) botversion
	regsub -all -- "%osbyteorder" $botversion $tcl_platform(byteOrder) botversion
	regsub -all -- "%user" $botversion $tcl_platform(user) botversion
	regsub -all -- "%machine" $botversion $tcl_platform(machine) botversion
	regsub -all -- "%platform" $botversion $tcl_platform(platform) botversion
	regsub -all -- "%version" $pub_setting(hversion) $version bothversion
	regsub -all -- "%ostype" $bothversion $tcl_platform(os) bothversion
	regsub -all -- "%osversion" $bothversion $tcl_platform(osVersion) bothversion
	regsub -all -- "%osbyteorder" $bothversion $tcl_platform(byteOrder) bothversion
	regsub -all -- "%user" $bothversion $tcl_platform(user) bothversion
	regsub -all -- "%machine" $bothversion $tcl_platform(machine) bothversion
	regsub -all -- "%platform" $bothversion $tcl_platform(platform) bothversion
	if {!$authed} {
		if {$pub_setting(noticeacc) && [lsearch -exact $pub_setting(commandlist) $cmd] != -1} { putserv "NOTICE $nick :You are not authorized. Please type \"/msg $botnick auth <password>\" to authorize yourself." }
		return
	}
	switch -- $cmd {
		"access" {
			set user [expr {([lindex $extxt 1] == "")?$nick:[lindex $extxt 1]}]
			pub_putmsg $chan [expr {([onchan $user $chan])?"[pub_getaccess $user $chan]":"$user is not on $chan."}]
		}
		"gethand" {
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) GetHand <nick>" ; return } 
			if {![onchan [lindex $extxt 1] $chan]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not on $chan." ; return }
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) GetHand <nick>" ; return }
			pub_putmsg $chan [expr [validuser [nick2hand [lindex $extxt 1]]]?"[pub_sindex $extxt 1]'s handle is [nick2hand [lindex $extxt 1]].":"[pub_sindex $extxt 1] is not a bot user."]
		}
		"invite" {
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Invite \[nick\] <channel>" ; return }
			if {[lindex $extxt 2] != ""} {
				if {![validchan [lindex $extxt 2]] || ![botonchan [lindex $extxt 2]]} { pub_putmsg $chan "I am not on [pub_sindex $extxt 2]." ; return }
				if {![onchan [lindex $extxt 1] $chan]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not on $chan." ; return }
				if {[onchan [lindex $extxt 1] [lindex $extxt 2]]} { pub_putmsg $chan "[pub_sindex $extxt 1] is already on [pub_sindex $extxt 2]." ; return }
				putserv "INVITE [pub_sindex $extxt 1] [pub_sindex $extxt 2]"
				pub_putmsg $chan "[pub_sindex $extxt 1] has been invited to [pub_sindex $extxt 2]."
				return
			}
			if {![validchan [lindex $extxt 1]] || ![botonchan [lindex $extxt 1]]} { pub_putmsg $chan "I am not on [pub_sindex $extxt 1]." ; return }
			if {[matchattr $hand o|o [lindex $extxt 1]] && ![matchattr $hand d|d [lindex $extxt 1]]} { putserv "INVITE $nick [pub_sindex $extxt 1]"	}
			if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Op access to [pub_sindex $extxt 1]" }
		}
		"die" {
			if {!$pub_setting(enable-die)} { return }
			if {![matchattr $hand n]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Owner access." }
				return
			}
			die "[lrange $extxt 1 end] \($hand\)"
		}
		"chattr" {
			if {![matchattr $hand n]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Owner access." }
				return
			}
			if {[lindex $extxt 2] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Chattr <nick> <flags> \[channel\]" ; return }
			if {![validuser [nick2hand [lindex $extxt 1]]]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not a bot user." ; return }
			if {[lindex $extxt 3] == ""} { pub_putmsg $chan "Global flags for [pub_sindex $extxt 1] are now [chattr [lindex $extxt 1] [lindex $extxt 2]]." ; return }
			pub_putmsg $chan [expr ([validchan [lindex $extxt 3]])?"Channel flags for [pub_sindex $extxt 1] on [pub_sindex $extxt 3] are now [lindex [split [chattr [lindex $extxt 1] [lindex [split $text] 2] [lindex $extxt 3]] |] 1].":"[lindex $extxt 3] is not a valid channel."]
			
		}
		"randpass" {
			if {![matchattr $hand n]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Owner access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) RandPass <nick>" ; return }
			if {![validuser [nick2hand [lindex $extxt 1]]]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not a bot user." ; return }
			if {![passwdok [nick2hand [lindex $extxt 1]] ""]} { pub_putmsg $chan "[pub_sindex $extxt 1] already has a password set." ; return }
			setuser [lindex $extxt 1] PASS [encrypt [rand $pub_setting(rand)] $pub_setting(key)]
			pub_putmsg $chan "Password set."
		}
		"+chan" {
			if {![matchattr $hand n]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Owner access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) +Chan <channel>" ; return }
			if {![regexp {^[\\+!#&]} [pub_sindex $extxt 1]]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not a valid channel." ; return }
			if {[validchan [lindex $extxt 1]]} { pub_putmsg $chan "[pub_sindex $extxt 1] is already in the channel list." ; return }
			channel add [lindex $extxt 1]
			pub_putmsg $chan "[pub_sindex $extxt 1] has been added to the channel list."
		}
		"-chan" {
			if {![matchattr $hand n]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Owner access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) -Chan <channel>" ; return }
			if {![validchan [lindex $extxt 1]]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not in the channel list." ; return }
			channel remove [lindex $extxt 1]
			pub_putmsg $chan "[pub_sindex $extxt 1] has been removed from the channel list."
		}
		"raw" {
			if {![matchattr $hand n]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Owner access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Raw <commands>" ; return }
			putserv "[join [lrange $extxt 1 end]]"
			pub_putmsg $chan "Raw commands have been sent."
		}
		"restart" {
			if {![matchattr $hand n]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Owner access." }
				return
			}
			putquick "PRIVMSG $chan :Restarting."
			restart
		}
		"disable" {
			if {![matchattr $hand n]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Owner access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Disable <nick>" ; return }
			if {![validuser [nick2hand [lindex $extxt 1]]]} { pub_putmsg $chan "No handle found for [pub_sindex $extxt 1]." ; return }
			if {[matchattr [nick2hand [lindex $extxt 1]] D]} { pub_putmsg $chan "[nick2hand [lindex $extxt 1]] is already disabled." ; return }
			chattr [nick2hand [lindex $extxt 1]] +D
			pub_putmsg $chan "[nick2hand [lindex $extxt 1]] has been disabled."
		}
		"enable" {
			if {![matchattr $hand n]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Owner access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Enable <nick>" ; return }
			if {![validuser [nick2hand [lindex $extxt 1]]]} { pub_putmsg $chan "No handle found for [pub_sindex $extxt 1]."  ; return }
			if {![matchattr [nick2hand [lindex $extxt 1]] D]} { pub_putmsg $chan "[nick2hand [lindex $extxt 1]] is already enabled."  ; return }
			chattr [nick2hand [lindex $extxt 1]] -D
			pub_putmsg $chan "[nick2hand [lindex $extxt 1]] has been enabled."
		}
		"rehash" {
			if {![matchattr $hand m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Master access." }
				return
			}
			putquick "PRIVMSG $chan :Rehashing."
			rehash
		}
		"jump" {
			if {![matchattr $hand m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Master access." }
				return
			}
			if {[lindex $extxt 1] != ""} { jump [lindex $extxt 1] } { jump }
		}
		"hosts" {
			if {![matchattr $hand m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Master access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Hosts <nick>" ; return }
			if {![onchan [lindex $extxt 1] $chan]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not on $chan." ; return }
			if {![validuser [nick2hand [lindex $extxt 1]]]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not a bot user." ;  return }
			set h [join [getuser [nick2hand [lindex $extxt 1]] HOSTS]]
			pub_putmsg $chan [expr {($h == "")?"[pub_sindex $extxt 1] has no hosts set.":$h}]
		}
		"uptime" {
			if {![matchattr $hand m|m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Master access." }
				return
			}
			pub_putmsg $chan "Uptime: $botuptime"
		}
		"unixtime" { pub_putmsg $chan "[unixtime] seconds have elapsed since January 1, 1970 00:00 GMT." }
		"time" { pub_putmsg $chan "The current time is [clock format [clock seconds] -format "%I:%M %p %D (%Z)"]." }
		"chanlist" {
			if {![matchattr $hand m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Master access." }
				return
			}
			pub_putmsg $chan "Channel list: [channels]"
		}
		"version" { pub_putmsg $chan "Version: [expr {([matchattr $hand m]) ? "$botversion" : "$bothversion"}]" }
		"+host" {
			if {![matchattr $hand m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Master access." }
				return
			}
			if {[lindex $extxt 2] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) +host <nick> <host>" ; return }
			if {![validuser [lindex $extxt 1]]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not a bot user." ; return }
			setuser [lindex $extxt 1] HOSTS [lindex $extxt 2]
			pub_putmsg $chan "[lindex $extxt 2] has been added to [pub_sindex $extxt 1]'s host list."
		}
		"-host" {
			if {![matchattr $hand m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Master access." }
				return
			}
			if {[lindex $extxt 2] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) -host <nick> <host>" ; return }
			if {![validuser [lindex $extxt 1]]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not a bot user." ; return }
			if {[set hd [expr ([lsearch -exact [getuser [nick2hand [lindex $extxt 1]] HOSTS] [lindex $extxt 2]] != -1)?1:0]]} { delhost [nick2hand [lindex $extxt 1]] [lindex $extxt 2] ; return }
			pub_putmsg $chan "[lindex $extxt 2] does not exist on [pub_sindex $extxt 1]'s host list."
		}
		"global" {
			if {![matchattr $hand m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Master access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Global <message>" ; return }
			foreach c [channels] {
				if {[botonchan $c]} { pub_putmsg $c "Global: [join [lrange $extxt 1 end]] \($nick\)" }
			}
		}
		"cycle" {
			if {![matchattr $hand m|m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Master access." }
				return
			}
			channel set $chan +inactive
			channel set $chan -inactive
		}
		"subop" {
			if {![matchattr $hand o|o]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Master access." }
				return
			}
			if {!$usesubop} { pub_putmsg $chan "SubOp is not enabled for $chan." ; return }
			if {[lindex $extxt 2] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) SubOp <add/del> <nick>" ; return }
			if {[pub_ncm [pub_sindex $extxt 1] add]} {
				if {![onchan [lindex $extxt 2] $chan]} { pub_putmsg $chan "[lindex $extxt 2] is not on $chan." ; return }
				if {![validuser [nick2hand [lindex $extxt 2]]]} {
					set h2add [string range [lindex $extxt 2] 0 [expr $handlen - 1]]
					adduser $h2add [maskhost [getchanhost [lindex $extxt 2]]]
					chattr $h2add |+v$pub_setting(subop_flag) $chan
					if {![isvoice [lindex $extxt 2] $chan]} { putserv "MODE $chan +v [lindex $extxt 2]" }
					pub_putmsg $chan "Access for [lindex $extxt 2] has been changed to [pub_bold {Channel SubOp}]."
					putserv "NOTICE [lindex $extxt 2] :Your access for $chan has been changed to [pub_bold {Channel SubOp}]. Please set a password by typing \"/msg $botnick PASS <new password>\"."
					return
				}
				if {[matchattr [nick2hand [lindex $extxt 2]] |+v$pub_setting(subop_flag) $chan]} { pub_putmsg $chan "[lindex $extxt 2] already exists on the Channel SubOp list for $chan." ; return }
				chattr [nick2hand [lindex $extxt 2]] |+v$pub_setting(subop_flag) $chan
				if {![isvoice [lindex $extxt 2] $chan]} { putserv "MODE $chan +v [lindex $extxt 2]" }
				pub_putmsg $chan "Access for [lindex $extxt 2] has been changed to [pub_bold {Channel SubOp}]."
				if {[passwdok [nick2hand [lindex $extxt 2]] ""]} { putserv "NOTICE [lindex $extxt 2] :Your access for $chan has been changed to [pub_bold {Channel SubOp}]. Please set a password by typing \"/msg $botnick PASS <new password>\"." }
				return
			}
			if {[pub_ncm [pub_sindex $extxt 1] del]} {
				if {![onchan [lindex $extxt 2] $chan]} { pub_putmsg $chan "[lindex $extxt 2] is not on $chan." ; return }
				if {![validuser [nick2hand [lindex $extxt 2]]] || ![matchattr [nick2hand [lindex $extxt 2]] |+v$pub_setting(subop_flag) $chan]} { pub_putmsg $chan "[lindex $extxt 2] does not have Channel SubOp access to $chan." ; return }
				chattr [nick2hand [lindex $extxt 2]] |-$pub_setting(subop_flag) $chan
				pub_putmsg $chan "[lindex $extxt 2] has been removed from the Channel SubOp list of $chan."
				return
			}
			puthelp "NOTICE $nick :Usage: $pub_setting(prefix) SubOp <add/del> <nick>"
		}
		"aop" {
			if {![matchattr $hand m|m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Master access." }
				return
			}
			if {[lindex $extxt 2] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) AOP <add/del> <nick>" ; return }
			if {[pub_ncm [pub_sindex $extxt 1] add]} {
				if {![onchan [lindex $extxt 2] $chan]} { pub_putmsg $chan "[lindex $extxt 2] is not on $chan." ; return }
				if {![validuser [nick2hand [lindex $extxt 2]]]} {
					set h2add [string range [lindex $extxt 2] 0 [expr $handlen - 1]]
					adduser $h2add [maskhost [getchanhost [lindex $extxt 2]]]
					chattr $h2add |+o $chan
					if {![isop [lindex $extxt 2] $chan]} { putserv "MODE $chan +o [lindex $extxt 2]" }
					pub_putmsg $chan "Access for [lindex $extxt 2] has been changed to [pub_bold {Channel Op}]."
					putserv "NOTICE [lindex $extxt 2] :Your access for $chan has been changed to [pub_bold {Channel Op}]. Please set a password by typing \"/msg $botnick PASS <new password>\"."
					return
				}
				if {[matchattr [nick2hand [lindex $extxt 2]] |+o $chan]} { pub_putmsg $chan "[lindex $extxt 2] already exists on the Channel Op list for $chan." ; return }
				chattr [nick2hand [lindex $extxt 2]] |+o $chan
				if {![isop [lindex $extxt 2] $chan]} { putserv "MODE $chan +o [lindex $extxt 2]" }
				pub_putmsg $chan "Access for [lindex $extxt 2] has been changed to [pub_bold {Channel Op}]."
				if {[passwdok [nick2hand [lindex $extxt 2]] ""]} { putserv "NOTICE [lindex $extxt 2] :Your access for $chan has been changed to [pub_bold {Channel Op}]. Please set a password by typing \"/msg $botnick PASS <new password>\"." }
				return
			}
			if {[pub_ncm [pub_sindex $extxt 1] del]} {
				if {![onchan [lindex $extxt 2] $chan]} { pub_putmsg $chan "[lindex $extxt 2] is not on $chan." ; return }
				if {![validuser [nick2hand [lindex $extxt 2]]] || ![matchattr [nick2hand [lindex $extxt 2]] |o $chan]} { pub_putmsg $chan "[lindex $extxt 2] does not have Channel Op access to $chan." ; return }
				chattr [nick2hand [lindex $extxt 2]] |-o $chan
				if {[isop $nick $chan]} { putserv "MODE $chan -o [lindex $extxt 2]" }
				pub_putmsg $chan "[lindex $extxt 2] has been removed from the Channel Op list of $chan."
				return
			}
			puthelp "NOTICE $nick :Usage: $pub_setting(prefix) AOP <add/del> <nick>"
		}
		"master" {
			if {![matchattr $hand n|n]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Owner access." }
				return
			}
			if {[lindex $extxt 2] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Master <add/del> <nick>" ; return }
			if {[pub_ncm [pub_sindex $extxt 1] add]} {
				if {![onchan [lindex $extxt 2] $chan]} { pub_putmsg $chan "[lindex $extxt 2] is not on $chan." ; return }
				if {![validuser [nick2hand [lindex $extxt 2]]]} {
					set h2add [string range [lindex $extxt 2] 0 [expr $handlen - 1]]
					adduser $h2add [maskhost [getchanhost [lindex $extxt 2]]]
					chattr $h2add |+m $chan
					if {![isop [lindex $extxt 2] $chan]} { putserv "MODE $chan +o [lindex $extxt 2]" }
					pub_putmsg $chan "Access for [lindex $extxt 2] has been changed to [pub_bold {Channel Master}]."
					putserv "NOTICE [lindex $extxt 2] :Your access for $chan has been changed to [pub_bold {Channel Master}]. Please set a password by typing \"/msg $botnick PASS <new password>\"."
					return
				}
				if {[matchattr [nick2hand [lindex $extxt 2]] |+m $chan]} { pub_putmsg $chan "[lindex $extxt 2] already exists on the Channel Master list for $chan." ; return }
				chattr [nick2hand [lindex $extxt 2]] |+m $chan
				if {![isop [lindex $extxt 2] $chan]} { putserv "MODE $chan +o [lindex $extxt 2]" }
				pub_putmsg $chan "Access for [lindex $extxt 2] has been changed to [pub_bold {Channel Master}]."
				if {[passwdok [nick2hand [lindex $extxt 2]] ""]} { putserv "NOTICE [lindex $extxt 2] :Your access for $chan has been changed to [pub_bold {Channel Master}]. Please set a password by typing \"/msg $botnick PASS <new password>\"." }
				return
			}
			if {[pub_ncm [pub_sindex $extxt 1] del]} {
				if {![onchan [lindex $extxt 2] $chan]} { pub_putmsg $chan "[lindex $extxt 2] is not on $chan." ; return }
				if {![validuser [nick2hand [lindex $extxt 2]]] || ![matchattr [nick2hand [lindex $extxt 2]] |m $chan]} { pub_putmsg $chan "[lindex $extxt 2] does not have Channel Master access to $chan." ; return }
				chattr [nick2hand [lindex $extxt 2]] |-m $chan
				pub_putmsg $chan "[lindex $extxt 2] has been removed from the Channel Master list of $chan."
				return
			}
			puthelp "NOTICE $nick :Usage: $pub_setting(prefix) master <add/del> <nick>"
		}
		"owner" {
			if {![matchattr $hand n]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Owner access." }
				return
			}
			if {[lindex $extxt 2] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Owner <add/del> <nick>" ; return }
			if {[pub_ncm [pub_sindex $extxt 1] add]} {
				if {![onchan [lindex $extxt 2] $chan]} { pub_putmsg $chan "[lindex $extxt 2] is not on $chan." ; return }
				if {![validuser [nick2hand [lindex $extxt 2]]]} {
					set h2add [string range [lindex $extxt 2] 0 [expr $handlen - 1]]
					adduser $h2add [maskhost [getchanhost [lindex $extxt 2]]]
					chattr $h2add |+n $chan
					if {![isop [lindex $extxt 2] $chan]} { putserv "MODE $chan +o [lindex $extxt 2]" }
					pub_putmsg $chan "Access for [lindex $extxt 2] has been changed to [pub_bold {Channel Owner}]."
					putserv "NOTICE [lindex $extxt 2] :Your access for $chan has been changed to [pub_bold {Channel Owner}]. Please set a password by typing \"/msg $botnick PASS <new password>\"."
					return
				}
				if {[matchattr [nick2hand [lindex $extxt 2]] |+n $chan]} { pub_putmsg $chan "[lindex $extxt 2] already exists on the Channel Owner list for $chan." ; return }
				chattr [nick2hand [lindex $extxt 2]] |+n $chan
				if {![isop [lindex $extxt 2] $chan]} { putserv "MODE $chan +o [lindex $extxt 2]" }
				pub_putmsg $chan "Access for [lindex $extxt 2] has been changed to [pub_bold {Channel Owner}]."
				if {[passwdok [nick2hand [lindex $extxt 2]] ""]} { putserv "NOTICE [lindex $extxt 2] :Your access for $chan has been changed to [pub_bold {Channel Owner}]. Please set a password by typing \"/msg $botnick PASS <new password>\"." }
				return
			}
			if {[pub_ncm [pub_sindex $extxt 1] del]} {
				if {![onchan [lindex $extxt 2] $chan]} { pub_putmsg $chan "[lindex $extxt 2] is not on $chan." ; return }
				if {![validuser [nick2hand [lindex $extxt 2]]] || ![matchattr [nick2hand [lindex $extxt 2]] |n $chan]} { pub_putmsg $chan "[lindex $extxt 2] does not have Channel Owner access to $chan." ; return }
				chattr [nick2hand [lindex $extxt 2]] |-n $chan
				pub_putmsg $chan "[lindex $extxt 2] has been removed from the Channel Owner list of $chan."
				return
			}
			puthelp "NOTICE $nick :Usage: $pub_setting(prefix) owner <add/del> <nick>"
		}
		"autovoice" {
			if {![matchattr $hand o|o $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Op access." }
				return
			}
			if {[lindex $extxt 2] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Autovoice <add/del> <nick>" ; return }
			if {[pub_ncm [pub_sindex $extxt 1] add]} {
				if {![onchan [lindex $extxt 2] $chan]} { pub_putmsg $chan "[lindex $extxt 2] is not on $chan." ; return }
				if {![validuser [nick2hand [lindex $extxt 2]]]} {
					set h2add [string range [lindex $extxt 2] 0 [expr $handlen - 1]]
					adduser $h2add [maskhost [getchanhost [lindex $extxt 2]]]
					chattr $h2add |+v $chan
					if {![isvoice [lindex $extxt 2] $chan]} { putserv "MODE $chan +v [lindex $extxt 2]" }
					pub_putmsg $chan "Access for [lindex $extxt 2] has been changed to [pub_bold {Channel Auto-Voice}]."
					putserv "NOTICE [lindex $extxt 2] :Your access for $chan has been changed to [pub_bold {Channel Auto-Voice}]. Please set a password by typing \"/msg $botnick PASS <new password>\"."
					return
				}
				if {[matchattr [nick2hand [lindex $extxt 2]] |+v $chan]} { pub_putmsg $chan "[lindex $extxt 2] already exists on the Channel Auto-Voice list for $chan." ; return }
				chattr [nick2hand [lindex $extxt 2]] |+n $chan
				if {![isvoice [lindex $extxt 2] $chan]} { putserv "MODE $chan +v [lindex $extxt 2]" }
				pub_putmsg $chan "Access for [lindex $extxt 2] has been changed to [pub_bold {Channel Auto-Voice}]."
				if {[passwdok [nick2hand [lindex $extxt 2]] ""]} { putserv "NOTICE [lindex $extxt 2] :Your access for $chan has been changed to [pub_bold {Channel Auto-Voice}]. Please set a password by typing \"/msg $botnick PASS <new password>\"." }
				return
			}
			if {[pub_ncm [pub_sindex $extxt 1] del]} {
				if {![onchan [lindex $extxt 2] $chan]} { pub_putmsg $chan "[lindex $extxt 2] is not on $chan." ; return }
				if {![validuser [nick2hand [lindex $extxt 2]]] || ![matchattr [nick2hand [lindex $extxt 2]] |n $chan]} { pub_putmsg $chan "[lindex $extxt 2] does not have Channel Auto-Voice access to $chan." ; return }
				chattr [nick2hand [lindex $extxt 2]] |-v $chan
				if {[isvoice [lindex $extxt 2] $chan]} { putserv "MODE $chan -v [lindex $extxt 2]" }
				pub_putmsg $chan "[lindex $extxt 2] has been removed from the Channel Auto-Voice list of $chan."
				return
			}
			puthelp "NOTICE $nick :Usage: $pub_setting(prefix) autovoice <add/del> <nick>"
		}
		"wipe" {
			if {![matchattr $hand n $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Owner access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Wipe <nick>" ; return }
			if {[matchattr [nick2hand [lindex $extxt 2]] +n]} { pub_putmsg $chan "[lindex $extxt 2] has global owner access and cannot be wiped." ; return }
			if {![onchan [lindex $extxt 2] $chan]} { pub_putmsg $chan "[lindex $extxt 2] is not on $chan." ; return }
			if {![validuser [nick2hand [lindex $extxt 2]]]} { pub_putmsg $chan "[lindex $extxt 2] has no access to $chan." ; return }
			chattr [nick2hand [lindex $extxt 2]] -|- $chan
			if {[isop [lindex $extxt 2]$chan]} { putserv "MODE $chan -o [lindex $extxt 2]" }
			if {[isvoice [lindex $extxt 2] $chan]} { putserv "MODE $chan -v [lindex $extxt 2]" }
			pub_putmsg $chan "Access for [lindex $extxt 2] has been wiped."
		}
		"act" {
			if {![matchattr $hand m|m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Master access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Act <action>" ; return }
			putserv "PRIVMSG $chan :\001ACTION [join [lrange $extxt 1 end]]\001"
		}
		"say" {
			if {![matchattr $hand m|m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Master access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Say <message>" ; return }
			putserv "PRIVMSG $chan :[join [lrange $extxt 1 end]]"
		}
		"akick" {
			if {![matchattr $hand m|m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Master access." }
				return
			}
			if {[lindex $extxt 1] == "" || (![pub_ncm *!*@* [lindex $extxt 2]] && ![pub_ncm [pub_sindex $extxt 1] list] && [lindex $extxt 2] == "")} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Akick <add/del/list> \[<host>\] \[reason\]." ; return }
			if {[pub_ncm [pub_sindex $extxt 1] add]} {
				if {[isban [lindex $extxt 2] $chan]} { putserv "PRIVMSG $chan :[lindex $extxt 2] already exists on the Akick list of $chan." ; return }
				newchanban $chan [lindex $extxt 2] $nick [lrange $extxt 3 end] 0
				foreach u [chanlist $chan] {
					if {[pub_ncm [lindex $extxt 2] $u![getchanhost $u]]} { putserv "KICK $chan $u :[lrange $extxt 3 end]" }
				}
				putserv "PRIVMSG $chan :[lindex $extxt 2] has been added to the Akick list of $chan."
				return
			}
			if {[pub_ncm [pub_sindex $extxt 1] del]} {
				if {![isban [lindex $extxt 2] $chan]} { putserv "PRIVMSG $chan :[lindex $extxt 2] does not exist on the Akick list of $chan." ; return }
				killchanban $chan [lindex $extxt 2]
				putserv "PRIVMSG $chan :[lindex $extxt 2] has been removed from the Akick list of $chan."
				return
			}
			if {[pub_ncm [pub_sindex $extxt 1] list]} {
				if {[banlist $chan] == ""} { puthelp "NOTICE $nick :The akick list for $chan is empty." ; return }
				puthelp "NOTICE $nick :$chan Akick list:"
				foreach b [banlist $chan] { puthelp "NOTICE $nick :[lindex $b 0] \([lindex $b 5] \([lindex $b 1] \([clock format [lindex $b 3]]\)\)\)" }
				puthelp "NOTICE $nick :End of Akick list."
			}
		}
		"msg" {
			if {![matchattr $hand m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Global Master access." }
				return
			}
			if {[lindex $extxt 2] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Msg <nick/channel> <message>" ; return }
			putserv "PRIVMSG [pub_sindex $extxt 1] :[join [lrange $extxt 2 end]]"
		}
		"save" {
			if {![matchattr $hand m|m]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Master access." }
				return
			}
			pub_putmsg $chan "Saving channel and user files."
			save
		}
		"mode" {
			if {(![matchattr $hand o|o $chan] && ![isop $nick $chan]) || [matchattr $hand d|d $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Op access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Mode <modes>" ; return }
			putserv "MODE $chan [join [lrange $extxt 1 end]]"
		}
		"voice" {
			if {(![matchattr $hand o|o $chan] && ![isop $nick $chan] && (!$usesubop || ![matchattr $hand |+v$pub_setting(subop_flag)])) || [matchattr $hand d|d $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel [expr {($usesubop)?"SubOp":"Op"}] access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Voice <nick>"  ; return }
			if {![onchan [lindex $extxt 1] $chan]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not on $chan." ; return  }
			putserv "MODE $chan +v [pub_sindex $extxt 1]"
		}
		"devoice" {
			if {(![matchattr $hand o|o $chan] && ![isop $nick $chan] && (!$usesubop || ![matchattr $hand |+v$pub_setting(subop_flag)])) || [matchattr $hand d|d $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel [expr {($usesubop)?"SubOp":"Op"}] access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Devoice <nick>" ; return }
			if {![onchan [lindex $extxt 1] $chan]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not on $chan." ; return  }
			putserv "MODE $chan -v [pub_sindex $extxt 1]"
		}
		"op" {
			if {(![matchattr $hand o|o $chan] && ![isop $nick $chan]) || [matchattr $hand d|d $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Op access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Op <nick>" ; return }
			if {![onchan [lindex $extxt 1] $chan]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not on $chan." ; return }
			putserv "mode $chan +o [pub_sindex $extxt 1]"
		}
		"deop" {
			if {(![matchattr $hand o|o $chan] && ![isop $nick $chan]) || [matchattr $hand d|d $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Op access." }
				return
			}
			if {[pub_ncm [pub_sindex $extxt 1] $botnick]} { pub_putmsg $chan "$botnick cannot be deopd." ; return }
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Deop <nick>" ; return }
			if {![onchan [lindex $extxt 1] $chan]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not on $chan." ; return }
			putserv "mode $chan -o [pub_sindex $extxt 1]"
		}
		"deopme" {
			if {(![matchattr $hand o|o $chan] && ![isop $nick $chan]) || [matchattr $hand d|d $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Op access." }
				return
			}
			putserv "mode $chan -o $nick"
		}
		"opme" {
			if {(![matchattr $hand o|o $chan] && ![isop $nick $chan]) || [matchattr $hand d|d $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Op access." }
				return
			}
			putserv "mode $chan +o $nick"
		}
		"kick" {
			if {(![matchattr $hand o|o $chan] && ![isop $nick $chan] && (!$usesubop || ![matchattr $hand |+v$pub_setting(subop_flag)])) || [matchattr $hand d|d $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel [expr {($usesubop)?"SubOp":"Op"}] access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Kick <nick> \[reason\]" ; return }
			if {![matchattr $hand o|o $chan] && ![isop $nick $chan] && [isop [lindex $extxt 1] $chan]} { pub_putmsg $chan "SubOps cannot kick ops." ; return }
			if {[pub_ncm [lindex $extxt 1] $botnick]} { pub_putmsg $chan "$botnick cannot be kicked." ; return }
			if {![onchan [lindex $extxt 1] $chan]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not on $chan." ; return  }
			putserv "KICK $chan [pub_sindex $extxt 1] :[join [lrange $extxt 2 end]] \($nick\)"
		}
		"ban" {
			if {(![matchattr $hand o|o $chan] && ![isop $nick $chan] && (!$usesubop || ![matchattr $hand |+v$pub_setting(subop_flag)])) || [matchattr $hand d|d $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel [expr {($usesubop)?"SubOp":"Op"}] access." }
				return
			}
			if {[lindex $extxt 2] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Ban <nick/host> <reason>" ; return }
			if {![pub_ncm *!*@* [lindex $extxt 1]]} {
				if {![matchattr $hand o|o $chan] && ![isop $nick $chan] && [isop [lindex $extxt 1] $chan]} { pub_putmsg $chan "SubOps cannot ban ops." ; return }
				if {![onchan [lindex $extxt 1] $chan]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not on $chan." ; return }
				putserv "MODE $chan +b [maskhost [lindex $extxt 1]![getchanhost [lindex $extxt 1]]]"
				putserv "KICK $chan [pub_sindex $extxt 1] :[join [lrange $extxt 2 end]] \($nick\)"
				return
			}
			if {![onchan [lindex $extxt 1] $chan]} { pub_putmsg $chan "[pub_sindex $extxt 1] is not on $chan." ; return  }
			if {![matchattr $hand o|o $chan] && ![isop $nick $chan]} {
				foreach u [chanlist $chan] {
					if {[isop $u $chan] && [pub_ncm [lindex $extxt 1] $u![getchanhost $u]]} { pub_putmsg $chan "SubOps cannot ban ops." ; return }
				}
			}
			putserv "MODE $chan +b [pub_sindex $extxt 1]"
		}
		"unban" {
			if {(![matchattr $hand o|o $chan] && ![isop $nick $chan] && (!$usesubop || ![matchattr $hand |+v$pub_setting(subop_flag)])) || [matchattr $hand d|d $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel [expr {($usesubop)?"SubOp":"Op"}] access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Unban <banmask>" ; return }
			putserv "MODE $chan -b [pub_sindex $extxt 1]"
		}
		"topic" {
			if {(![matchattr $hand o|o $chan] && ![isop $nick $chan] && (!$usesubop || ![matchattr $hand |+v$pub_setting(subop_flag)])) || [matchattr $hand d|d $chan]} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel [expr {($usesubop)?"SubOp":"Op"}] access." }
				return
			}
			if {[lindex $extxt 1] == ""} { puthelp "NOTICE $nick :Usage: $pub_setting(prefix) Topic <new topic>" ; return }
			putserv "TOPIC $chan :[lrange $extxt 1 end]"
		}
		"voiceme" {
			if {![matchattr $hand vo|vo $chan] && ![isvoice $nick $chan] && ![isop $nick $chan] && (!$usesubop || ![matchattr $hand |+v$pub_setting(subop_flag)])} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Auto-Voice access." }
				return
			}
			putserv "MODE $chan +v $nick"
		}
		"devoiceme" {
			if {![matchattr $hand vo|vo $chan] && ![isvoice $nick $chan] && ![isop $nick $chan] && (!$usesubop || ![matchattr $hand |+v$pub_setting(subop_flag)])} {
				if {$pub_setting(noticeacc)} { putserv "NOTICE $nick :This command requires Channel Auto-Voice access." }
				return
			}
			putserv "MODE $chan -v $nick"
		}
		"help" {
			puthelp "NOTICE $nick :Usage: $pub_setting(prefix) <command>"
			puthelp "NOTICE $nick :Access: [pub_getaccess $hand $chan]"
			puthelp "NOTICE $nick :Commands:"
			if {[matchattr $hand n]} {
				puthelp "NOTICE $nick :+Chan <channel> - Adds a channel to the bot's channel list."
				puthelp "NOTICE $nick :-Chan <channel> - Removes a channel from the bot's channel list."
				puthelp "NOTICE $nick :+Host <nick> <host> - Adds a hostmask to a nick's handle."
				puthelp "NOTICE $nick :-Host <nick> <host> - Removes a hostmask from a nick's handle."
			}
			puthelp "NOTICE $nick :Access \[nick\] - Shows the access for a nick."
			if {[matchattr $hand m|m]} {
				puthelp "NOTICE $nick :Act <action> - Makes the bot preform an action in the channel."
				puthelp "NOTICE $nick :Akick <add/del/list> \[<host\] \[reason\] - Adds, deletes, and lists akicks in the channel."
				puthelp "NOTICE $nick :AOP <add/del> <nick> - Adds or removes a nick from the Channel Op list."
			}
			if {([matchattr $hand o|o $chan] || [isop $nick $chan] || ($usesubop && [matchattr $hand |+v$pub_setting(subop_flag)])) && ![matchattr $hand d|d $chan]} {
				puthelp "NOTICE $nick :Autovoice <add/del> <nick> - Adds or deletes a nick from the channel Auto-Voice list."
				puthelp "NOTICE $nick :Ban <nick/hostmask> <reason> - Adds a nick or host to the channel ban list."
			}
			if {[matchattr $hand m]} { puthelp "NOTICE $nick :Chanlist - Shows a list of channels the bot is on." }
			if {[matchattr $hand n]} { puthelp "NOTICE $nick :Chattr <nick> <flags> \[channel\] - Changes the flags of a user." }
			if {[matchattr $hand m]} { puthelp "NOTICE $nick :Cycle - Makes the bot cycle the channel." }
			if {([matchattr $hand o|o $chan] || [isop $nick $chan]) && ![matchattr $hand d|d $chan]} {
				puthelp "NOTICE $nick :Deop - Makes the bot de-op a nick."
				puthelp "NOTICE $nick :Deopme - Makes the bot de-op you."
			}
			if {([matchattr $hand o|o $chan] || [isop $nick $chan] || ($usesubop && [matchattr $hand |+v$pub_setting(subop_flag)])) && ![matchattr $hand d|d $chan]} { puthelp "NOTICE $nick :Devoice <nick> - Makes the bot de-voice a nick." }
			if {[matchattr $hand ov|ov $chan] || [isop $nick $chan] || [isvoice $nick $chan] || ($usesubop && [matchattr $hand |+v$pub_setting(subop_flag)])} { puthelp "NOTICE $nick :Devoiceme - Makes the bot de-voice you." }
			if {[matchattr $hand n]} {
				if {$pub_setting(enable-die) && [matchattr $hand n]} { puthelp "NOTICE $nick :Die - Kills the bot." }
				puthelp "NOTICE $nick :Disable <nick> - Prevents a nick from using any of the commands."
				puthelp "NOTICE $nick :Enable <nick> - Allows a nick to use commands after being disabled."
			}
			puthelp "NOTICE $nick :GetHand <nick> - Shows the handle of a nick."
			if {[matchattr $hand m]} {
				puthelp "NOTICE $nick :Global <message> - Sends a message to every channel the bot is on."
				puthelp "NOTICE $nick :Hosts <nick> - Shows all hostmasks for a nick's handle."
			}
			puthelp "NOTICE $nick :Help - Shows this help message."
			puthelp "NOTICE $nick :Invite \[nick\] <channel> - Invites you or another nick to a channel."
			if {[matchattr $hand m]} { puthelp "NOTICE $nick :Jump \[server\] - Makes the bot change servers." }
			if {([matchattr $hand o|o $chan] || [isop $nick $chan] || ($usesubop && [matchattr $hand |+v$pub_setting(subop_flag)])) && (![matchattr $hand d|d $chan])} { puthelp "NOTICE $nick :Kick <nick> \[reason\] - Kicks a nick from the channel." }
			if {[matchattr $hand n|n]} { puthelp "NOTICE $nick :Master <add/del> <nick> - Adds or removes a nick from the Channel Master list." }
			if {([matchattr $hand o|o $chan] || [isop $nick $chan]) && ![matchattr $hand d|d $chan]} { puthelp "NOTICE $nick :Mode <modes> - Sets a mode on the channel." }
			if {[matchattr $hand m]} { puthelp "NOTICE $nick :Msg <nick/channel> - Sends a message to a nick or channel." }
			if {([matchattr $hand o|o $chan] || [isop $nick $chan]) && ![matchattr $hand d|d $chan]} {
				puthelp "NOTICE $nick :Op <nick> - Makes the bot op a nick."
				puthelp "NOTICE $nick :Opme - Makes the bot op you."
			}
			if {[matchattr $hand n]} {
				puthelp "NOTICE $nick :Owner <add/del> <nick> - Adds or removes a nick from the Channel Owner list."
				puthelp "NOTICE $nick :RandPass <nick> - Sets a random password for a nick."
				puthelp "NOTICE $nick :Raw <commands> - Sends raw commands to the irc server."
			}
			if {[matchattr $hand m]} { puthelp "NOTICE $nick :Rehash - Rehashes the bot." }
			if {[matchattr $hand n]} { puthelp "NOTICE $nick :Restart - Restarts the bot." }
			if {[matchattr $hand m|m]} {
				puthelp "NOTICE $nick :Save - Saves the bot's userfile."
				puthelp "NOTICE $nick :Say - Makes the bot say something in the channel."
			}
			if {$usesubop && ([matchattr $hand o|o $chan] || [isop $nick $chan]) && ![matchattr $hand d|d $chan]} { puthelp "NOTICE $nick :SubOp - Adds or removes a nick from the channel SubOp list." }
			if {([matchattr $hand o|o $chan] || [isop $nick $chan] || ($usesubop && [matchattr $hand |+v$pub_setting(subop_flag)])) && ![matchattr $hand d|d $chan]} {
				puthelp "NOTICE $nick :Topic <new topic> - Sets a new topic on the channel."
				puthelp "NOTICE $nick :Unban <banmask> - Makes the bot unban a banmask."
			}
			if {[matchattr $hand m]} { puthelp "NOTICE $nick :Uptime - Shows the bot's uptime." }
			puthelp "NOTICE $nick :Version - Shows the bot's version[expr ([matchattr $hand m])?" and operating system.":""]."
			if {([matchattr $hand o|o $chan] || [isop $nick $chan] || ($usesubop && [matchattr $hand |+v$pub_setting(subop_flag)])) && ![matchattr $hand d|d $chan]} { puthelp "NOTICE $nick :Voice <nick> - Makes the bot voice a nick." }
			if {[matchattr $hand ov|ov $chan] || [isop $nick $chan] || [isvoice $nick $chan] || ($usesubop && [matchattr $hand |+v$pub_setting(subop_flag)])} { puthelp "NOTICE $nick :Voiceme - Makes the bot voice you." }
			if {[matchattr $hand n]} { puthelp "NOTICE $nick :Wipe <nick> - Wipes all access from a nick." }
		}
	}
}
proc pub_getaccess {user chan} {
	global botnick pub_setting
	set usesubop [expr ([lsearch -exact [channel info $chan] +subop] != -1)?1:0]
	set host [getchanhost $user]
	set ouser $user
	set user [nick2hand $user]
	if {[pub_ncc $user $botnick] || [matchattr $user b]} { return "Access for $user \($host\) is [pub_bold Bot] \([chattr $user $chan]\)." }
	if {[matchattr $user n]} { return "Access for $user \($host\) is [pub_bold {Global Owner}] \([chattr $user $chan]\)." }
	if {[matchattr $user |n $chan]} { return "Access for $user \($host\) is [pub_bold {Channel Owner}] \([chattr $user $chan]\)." }
	if {[matchattr $user m]} { return "Access for $user \($host\) is [pub_bold {Global Master}] \([chattr $user $chan]\)." }
	if {[matchattr $user |m $chan]} { return "Access for $user \($host\) is [pub_bold {Channel Master}] \([chattr $user $chan]\)." }
	if {[matchattr $user o]} { return "Access for $user \($host\) is [pub_bold {Global Op}] \([chattr $user $chan]\)." }
	if {[matchattr $user |o $chan]} { return "Access for $user \($host\) is [pub_bold {Channel Op}] \([chattr $user $chan]\)." }
	if {[matchattr $user v$pub_setting(subop_flag)] && $usesubop} { return "Access for $user \($host\) is [pub_bold {Global SubOp}] \([chattr $user $chan]\)." }
	if {[matchattr $user |v$pub_setting(subop_flag) $chan] && $usesubop} { return "Access for $user \($host\) is [pub_bold {Channel SubOp}] \([chattr $user $chan]\)." }
	if {[matchattr $user v]} { return "Access for $user \($host\) is [pub_bold {Global Auto-Voice}] \([chattr $user $chan]\)." }
	if {[matchattr $user |v $chan]} { return "Access for $user \($host\) is [pub_bold {Channel Auto-Voice}] \([chattr $user $chan]\)." }
	if {[matchattr $user p]} { return "Access for $user \($host\) is [pub_bold {Global Partyline}] \([chattr $user $chan]\)." }
	return "Access for [expr {([pub_ncc $user *])?"$ouser":"$user"}] \($host\) is [pub_bold None]."
}
putlog "\002PUB:\002 Pub.tcl Version 1.8 BETA 3 by Wcc and MatriX- is loaded."